package gov.va.med.mhv.usermgmt.converter;

import gov.va.med.mhv.usermgmt.common.dto.UserAcceptTermsHistoryDTO;
import gov.va.med.mhv.usermgmt.data.model.UserAcceptTermsHistory;

public class UserAcceptTermsHistoryConverter extends AbstractConverter<UserAcceptTermsHistoryDTO, UserAcceptTermsHistory> {

	@Override
	public UserAcceptTermsHistoryDTO convertFrom(UserAcceptTermsHistory e) {
		UserAcceptTermsHistoryDTO enDTO = new UserAcceptTermsHistoryDTO();
		enDTO.setId(e.getId());
		enDTO.setUserUpdatedTime(e.getUserUpdatedTime());
		enDTO.setAccepted(e.getAccepted());
		enDTO.setUserProfileId(e.getUserProfileId());
		enDTO.setTermsCondVerHistId(e.getTermsCondVerHistId());
		return enDTO;
	}

	@Override
	public UserAcceptTermsHistory convertTo(UserAcceptTermsHistoryDTO enDto) {
		UserAcceptTermsHistory e = new UserAcceptTermsHistory();
		e.setId(enDto.getId());
		e.setUserUpdatedTime(enDto.getUserUpdatedTime());
		e.setAccepted(enDto.getAccepted());
		e.setUserProfileId(enDto.getUserProfileId());
		e.setTermsCondVerHistId(enDto.getTermsCondVerHistId());
		return e;
	}

}
